/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotMoleculeByOrderAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "molecule.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Descriptors/MoleculeOrderDescriptor.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "NotMoleculeByOrderAction.hpp"

// and construct the stuff
#include "NotMoleculeByOrderAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */

Action::state_ptr SelectionNotMoleculeByOrderAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  molecule *mol = World::getInstance().getMolecule(MoleculeByOrder(params.molindex));

  if (mol != NULL) {
    if (World::getInstance().isSelected(mol)) {
      DoLog(1) && (Log() << Verbose(1) << "Unselecting molecule " << mol->name << endl);
      World::getInstance().unselectMolecule(mol);
      DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedMolecules() << " molecules remain selected." << endl);
      return Action::state_ptr(new SelectionNotMoleculeByOrderState(mol, params));
    } else {
      return Action::success;
    }
  } else {
    return Action::failure;
  }
}

Action::state_ptr SelectionNotMoleculeByOrderAction::performUndo(Action::state_ptr _state) {
  SelectionNotMoleculeByOrderState *state = assert_cast<SelectionNotMoleculeByOrderState*>(_state.get());

  World::getInstance().selectMolecule(state->mol);
  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotMoleculeByOrderAction::performRedo(Action::state_ptr _state){
  SelectionNotMoleculeByOrderState *state = assert_cast<SelectionNotMoleculeByOrderState*>(_state.get());

  World::getInstance().unselectMolecule(state->mol);
  return Action::state_ptr(_state);
}

bool SelectionNotMoleculeByOrderAction::canUndo() {
  return true;
}

bool SelectionNotMoleculeByOrderAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
