/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotMoleculeByNameAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "molecule.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Descriptors/MoleculeNameDescriptor.hpp"
#include "Descriptors/MoleculeSelectionDescriptor.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "NotMoleculeByNameAction.hpp"

// and construct the stuff
#include "NotMoleculeByNameAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotMoleculeByNameAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Unselecting all molecule called " << params.molname << endl);
  std::vector<molecule *> unselectedMolecules =
      World::getInstance().getAllMolecules((!MoleculesBySelection()) && MoleculeByName(params.molname));
  World::getInstance().unselectAllMolecules(MoleculeByName(params.molname));
  DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedMolecules() << " molecules remain selected." << endl);

  return Action::state_ptr(new SelectionNotMoleculeByNameState(unselectedMolecules,params));
}

Action::state_ptr SelectionNotMoleculeByNameAction::performUndo(Action::state_ptr _state) {
  SelectionNotMoleculeByNameState *state = assert_cast<SelectionNotMoleculeByNameState*>(_state.get());

  World::getInstance().selectAllMolecules(MoleculeByName(state->params.molname));
  BOOST_FOREACH( molecule *mol, state->unselectedMolecules)
    World::getInstance().unselectMolecule(mol);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotMoleculeByNameAction::performRedo(Action::state_ptr _state){
  SelectionNotMoleculeByNameState *state = assert_cast<SelectionNotMoleculeByNameState*>(_state.get());

  World::getInstance().unselectAllMolecules(MoleculeByName(state->params.molname));

  return Action::state_ptr(_state);
}

bool SelectionNotMoleculeByNameAction::canUndo() {
  return true;
}

bool SelectionNotMoleculeByNameAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
