/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotMoleculeByIdAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "molecule.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "NotMoleculeByIdAction.hpp"

// and construct the stuff
#include "NotMoleculeByIdAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotMoleculeByIdAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  if (params.mol != NULL) {
    if (World::getInstance().isSelected(params.mol)) {
      DoLog(1) && (Log() << Verbose(1) << "Unselecting molecule " << params.mol->name << endl);
      World::getInstance().unselectMolecule(params.mol);
      DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedMolecules() << " molecules remain selected." << endl);
      return Action::state_ptr(new SelectionNotMoleculeByIdState(params));
    } else {
      return Action::success;
    }
  } else {
    return Action::failure;
  }
}

Action::state_ptr SelectionNotMoleculeByIdAction::performUndo(Action::state_ptr _state) {
  SelectionNotMoleculeByIdState *state = assert_cast<SelectionNotMoleculeByIdState*>(_state.get());

  World::getInstance().selectMolecule(state->params.mol);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotMoleculeByIdAction::performRedo(Action::state_ptr _state){
  SelectionNotMoleculeByIdState *state = assert_cast<SelectionNotMoleculeByIdState*>(_state.get());

  World::getInstance().unselectMolecule(state->params.mol);

  return Action::state_ptr(_state);
}

bool SelectionNotMoleculeByIdAction::canUndo() {
  return true;
}

bool SelectionNotMoleculeByIdAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
