/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotMoleculeByFormulaAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/MoleculeFormulaDescriptor.hpp"
#include "Descriptors/MoleculeSelectionDescriptor.hpp"
#include "molecule.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "NotMoleculeByFormulaAction.hpp"

// and construct the stuff
#include "NotMoleculeByFormulaAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotMoleculeByFormulaAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Unselecting molecules with chemical formula " << params.formula << ":" << endl);
  std::vector<molecule *> matchingMolecules = World::getInstance().getAllMolecules(MoleculeByFormula(params.formula));
  std::vector<molecule *> unselectedMolecules = World::getInstance().getAllMolecules(!MoleculesBySelection());
  World::getInstance().unselectAllMolecules(MoleculeByFormula(params.formula));
  DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedMolecules() << " molecules remain selected." << endl);
  return Action::state_ptr(new SelectionNotMoleculeByFormulaState(unselectedMolecules,params));
}

Action::state_ptr SelectionNotMoleculeByFormulaAction::performUndo(Action::state_ptr _state) {
  SelectionNotMoleculeByFormulaState *state = assert_cast<SelectionNotMoleculeByFormulaState*>(_state.get());

  World::getInstance().selectAllMolecules(MoleculeByFormula(state->params.formula));
  BOOST_FOREACH( molecule *mol, state->unselectedMolecules)
    World::getInstance().unselectMolecule(mol);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotMoleculeByFormulaAction::performRedo(Action::state_ptr _state){
  SelectionNotMoleculeByFormulaState *state = assert_cast<SelectionNotMoleculeByFormulaState*>(_state.get());

  World::getInstance().unselectAllMolecules(MoleculeByFormula(state->params.formula));

  return Action::state_ptr(_state);
}

bool SelectionNotMoleculeByFormulaAction::canUndo() {
  return true;
}

bool SelectionNotMoleculeByFormulaAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
