/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAllMoleculesAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/MoleculeDescriptor.hpp"
#include "atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "NotAllMoleculesAction.hpp"

// and construct the stuff
#include "NotAllMoleculesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAllMoleculesAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();
  DoLog(1) && (Log() << Verbose(1) << "Unselecting all molecules." << endl);
  World::getInstance().clearMoleculeSelection();
  DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedMolecules() << " molecules remain selected." << endl);
  return Action::state_ptr(new SelectionNotAllMoleculesState(selectedMolecules,params));
}

Action::state_ptr SelectionNotAllMoleculesAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllMoleculesState *state = assert_cast<SelectionNotAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  BOOST_FOREACH(molecule *_mol, state->unselectedMolecules)
    World::getInstance().selectMolecule(_mol);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAllMoleculesAction::performRedo(Action::state_ptr _state){
  //SelectionNotAllMoleculesState *state = assert_cast<SelectionNotAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();

  return Action::state_ptr(_state);
}

bool SelectionNotAllMoleculesAction::canUndo() {
  return true;
}

bool SelectionNotAllMoleculesAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
