/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeByOrderAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "molecule.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Descriptors/MoleculeOrderDescriptor.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "MoleculeByOrderAction.hpp"

// and construct the stuff
#include "MoleculeByOrderAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */

Action::state_ptr SelectionMoleculeByOrderAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  molecule *mol = World::getInstance().getMolecule(MoleculeByOrder(params.molindex));

  if (mol != NULL) {
    if (!World::getInstance().isSelected(mol)) {
      DoLog(1) && (Log() << Verbose(1) << "Selecting molecule " << mol->name << endl);
      World::getInstance().selectMolecule(mol);
      DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedMolecules() << " molecules selected." << endl);
      return Action::state_ptr(new SelectionMoleculeByOrderState(mol, params));
    } else {
      return Action::success;
    }
  } else {
    return Action::failure;
  }
}

Action::state_ptr SelectionMoleculeByOrderAction::performUndo(Action::state_ptr _state) {
  SelectionMoleculeByOrderState *state = assert_cast<SelectionMoleculeByOrderState*>(_state.get());

  World::getInstance().unselectMolecule(state->mol);
  return Action::state_ptr(_state);
}

Action::state_ptr SelectionMoleculeByOrderAction::performRedo(Action::state_ptr _state){
  SelectionMoleculeByOrderState *state = assert_cast<SelectionMoleculeByOrderState*>(_state.get());

  World::getInstance().selectMolecule(state->mol);
  return Action::state_ptr(_state);
}

bool SelectionMoleculeByOrderAction::canUndo() {
  return true;
}

bool SelectionMoleculeByOrderAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
