/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeByNameAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/MoleculeNameDescriptor.hpp"
#include "Descriptors/MoleculeSelectionDescriptor.hpp"
#include "molecule.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "MoleculeByNameAction.hpp"

// and construct the stuff
#include "MoleculeByNameAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionMoleculeByNameAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Selecting all molecules called " << params.molname << endl);
  std::vector<molecule *> selectedMolecules =
      World::getInstance().getAllMolecules(MoleculesBySelection() && MoleculeByName(params.molname));
  World::getInstance().selectAllMolecules(MoleculeByName(params.molname));
  DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedMolecules() << " molecules selected." << endl);

  return Action::state_ptr(new SelectionMoleculeByNameState(selectedMolecules,params));
}

Action::state_ptr SelectionMoleculeByNameAction::performUndo(Action::state_ptr _state) {
  SelectionMoleculeByNameState *state = assert_cast<SelectionMoleculeByNameState*>(_state.get());

  World::getInstance().unselectAllMolecules(MoleculeByName(state->params.molname));
  BOOST_FOREACH( molecule *mol, state->selectedMolecules)
    World::getInstance().selectMolecule(mol);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionMoleculeByNameAction::performRedo(Action::state_ptr _state){
  SelectionMoleculeByNameState *state = assert_cast<SelectionMoleculeByNameState*>(_state.get());

  World::getInstance().selectAllMolecules(MoleculeByName(state->params.molname));

  return Action::state_ptr(_state);
}

bool SelectionMoleculeByNameAction::canUndo() {
  return true;
}

bool SelectionMoleculeByNameAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
