/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeByFormulaAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/MoleculeFormulaDescriptor.hpp"
#include "Descriptors/MoleculeSelectionDescriptor.hpp"
#include "molecule.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "MoleculeByFormulaAction.hpp"

// and construct the stuff
#include "MoleculeByFormulaAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionMoleculeByFormulaAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Selecting molecules with chemical formula " << params.formula << ":" << endl);
//  std::vector<molecule *> matchingMolecules = World::getInstance().getAllMolecules(MoleculeByFormula(params.formula));
  std::vector<molecule *> selectedMolecules =
      World::getInstance().getAllMolecules(MoleculesBySelection() && MoleculeByFormula(params.formula));
//  BOOST_FOREACH(molecule *mol, matchingMolecules)
//    DoLog(1) && (Log() << Verbose(1) << "\t" << mol->getId() << ", " << mol->getName() << "." << endl);
  World::getInstance().selectAllMolecules(MoleculeByFormula(params.formula));
  DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedMolecules() << " molecules selected." << endl);
  return Action::state_ptr(new SelectionMoleculeByFormulaState(selectedMolecules,params));
}

Action::state_ptr SelectionMoleculeByFormulaAction::performUndo(Action::state_ptr _state) {
  SelectionMoleculeByFormulaState *state = assert_cast<SelectionMoleculeByFormulaState*>(_state.get());

  World::getInstance().unselectAllMolecules(MoleculeByFormula(state->params.formula));
  BOOST_FOREACH( molecule *mol, state->selectedMolecules)
    World::getInstance().selectMolecule(mol);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionMoleculeByFormulaAction::performRedo(Action::state_ptr _state){
  SelectionMoleculeByFormulaState *state = assert_cast<SelectionMoleculeByFormulaState*>(_state.get());

  World::getInstance().selectAllMolecules(MoleculeByFormula(state->params.formula));

  return Action::state_ptr(_state);
}

bool SelectionMoleculeByFormulaAction::canUndo() {
  return true;
}

bool SelectionMoleculeByFormulaAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
