/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ClearAllMoleculesAction.cpp
 *
 *  Created on: Aug 09, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/MoleculeDescriptor.hpp"
#include "atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "ClearAllMoleculesAction.hpp"

// and construct the stuff
#include "ClearAllMoleculesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionClearAllMoleculesAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();
  DoLog(1) && (Log() << Verbose(1) << "Clearing molecule selection." << endl);
  World::getInstance().clearMoleculeSelection();
  DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedMolecules() << " molecules remain selected." << endl);
  return Action::state_ptr(new SelectionClearAllMoleculesState(selectedMolecules,params));
}

Action::state_ptr SelectionClearAllMoleculesAction::performUndo(Action::state_ptr _state) {
  SelectionClearAllMoleculesState *state = assert_cast<SelectionClearAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  BOOST_FOREACH(molecule *_mol, state->selectedMolecules)
    World::getInstance().selectMolecule(_mol);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionClearAllMoleculesAction::performRedo(Action::state_ptr _state){
  //SelectionClearAllMoleculesState *state = assert_cast<SelectionClearAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();

  return Action::state_ptr(_state);
}

bool SelectionClearAllMoleculesAction::canUndo() {
  return true;
}

bool SelectionClearAllMoleculesAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
