/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AllMoleculesAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/MoleculeDescriptor.hpp"
#include "Descriptors/MoleculeSelectionDescriptor.hpp"
#include "atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "AllMoleculesAction.hpp"

// and construct the stuff
#include "AllMoleculesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAllMoleculesAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();
  DoLog(1) && (Log() << Verbose(1) << "Selecting all molecules." << endl);
  World::getInstance().selectAllMolecules(AllMolecules());
  DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedMolecules() << " molecules selected." << endl);
  return Action::state_ptr(new SelectionAllMoleculesState(selectedMolecules,params));
}

Action::state_ptr SelectionAllMoleculesAction::performUndo(Action::state_ptr _state) {
  SelectionAllMoleculesState *state = assert_cast<SelectionAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  BOOST_FOREACH(molecule *_mol, state->selectedMolecules)
    World::getInstance().selectMolecule(_mol);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAllMoleculesAction::performRedo(Action::state_ptr _state){
  //SelectionAllMoleculesState *state = assert_cast<SelectionAllMoleculesState*>(_state.get());

  World::getInstance().selectAllMolecules(AllMolecules());

  return Action::state_ptr(_state);
}

bool SelectionAllMoleculesAction::canUndo() {
  return true;
}

bool SelectionAllMoleculesAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
