/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAtomByElementAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "Descriptors/AtomTypeDescriptor.hpp"
#include "atom.hpp"
#include "element.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "NotAtomByElementAction.hpp"

// and construct the stuff
#include "NotAtomByElementAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAtomByElementAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Unselecting atoms of type " << *params.elemental << endl);
  std::vector<atom *> unselectedAtoms = World::getInstance().getAllAtoms(!AtomsBySelection());
  World::getInstance().unselectAllAtoms(AtomByType(params.elemental));
  DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedAtoms() << " atoms remain selected." << endl);
  return Action::state_ptr(new SelectionNotAtomByElementState(unselectedAtoms,params));
}

Action::state_ptr SelectionNotAtomByElementAction::performUndo(Action::state_ptr _state) {
  SelectionNotAtomByElementState *state = assert_cast<SelectionNotAtomByElementState*>(_state.get());

  World::getInstance().selectAllAtoms(AtomByType(state->params.elemental));
  BOOST_FOREACH(atom *_atom, state->unselectedAtoms)
    World::getInstance().unselectAtom(_atom);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAtomByElementAction::performRedo(Action::state_ptr _state){
  SelectionNotAtomByElementState *state = assert_cast<SelectionNotAtomByElementState*>(_state.get());

  World::getInstance().unselectAllAtoms(AtomByType(state->params.elemental));

  return Action::state_ptr(_state);
}

bool SelectionNotAtomByElementAction::canUndo() {
  return true;
}

bool SelectionNotAtomByElementAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
