/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AllAtomsInsideSphereAction.cpp
 *
 *  Created on: Aug 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomShapeDescriptor.hpp"
#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Shapes/BaseShapes.hpp"
#include "Shapes/Shape.hpp"
#include "Shapes/ShapeOps.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "AllAtomsInsideSphereAction.hpp"

// and construct the stuff
#include "AllAtomsInsideSphereAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAllAtomsInsideSphereAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Selecting all atoms inside a sphere at " << params.position << " with radius " << params.radius << "." << endl);
  Shape s = translate(resize(Sphere(),params.radius),params.position);
  std::vector<atom *> selectedAtoms = World::getInstance().getAllAtoms(AtomsBySelection() && AtomByShape(s));
  World::getInstance().selectAllAtoms(AtomByShape(s));
  DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedAtoms() << " atoms selected." << endl);
  return Action::state_ptr(new SelectionAllAtomsInsideSphereState(selectedAtoms, s, params));
}

Action::state_ptr SelectionAllAtomsInsideSphereAction::performUndo(Action::state_ptr _state) {
  SelectionAllAtomsInsideSphereState *state = assert_cast<SelectionAllAtomsInsideSphereState*>(_state.get());

  World::getInstance().unselectAllAtoms(AtomByShape(state->s));
  BOOST_FOREACH(atom *_atom, state->selectedAtoms)
    World::getInstance().selectAtom(_atom);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAllAtomsInsideSphereAction::performRedo(Action::state_ptr _state){
  SelectionAllAtomsInsideSphereState *state = assert_cast<SelectionAllAtomsInsideSphereState*>(_state.get());

  World::getInstance().selectAllAtoms(AtomByShape(state->s));

  return Action::state_ptr(_state);
}

bool SelectionAllAtomsInsideSphereAction::canUndo() {
  return true;
}

bool SelectionAllAtomsInsideSphereAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
