/*
 * memoryallocatorunittest.cpp
 */


using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "memoryallocator.hpp"
#include "memoryallocatorunittest.hpp"
#include "helpers.hpp"
#include "defs.hpp"

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( MemoryAllocatorTest );


void MemoryAllocatorTest::setUp()
{
};


void MemoryAllocatorTest::tearDown()
{
  MemoryUsageObserver::getInstance()->purgeInstance();
};

/**
 * UnitTest for Malloc()
 */
void MemoryAllocatorTest::MallocTest()
{
  int* buffer1 = NULL;
  buffer1 = Malloc<int>(1, "");
  Free(&buffer1);

  long* buffer2 = NULL;
  buffer2 = Malloc<long>(1, "");
  Free(&buffer2);

  char* buffer3 = NULL;
  buffer3 = Malloc<char>(4, "");
  DoLog(0) && (Log() << Verbose(0) << buffer3 << endl);
  Free(&buffer3);

  char** buffer4 = NULL;
  buffer4 = Malloc<char*>(10, "");
  for (int i=0;i<10;i++)
    buffer4[i] = NULL;
  Free(&buffer4);
};

/**
 * UnitTest for Calloc()
 */
void MemoryAllocatorTest::CallocTest()
{
  int* buffer1 = NULL;
  buffer1 = Calloc<int>(10, "");
  Free(&buffer1);

  long* buffer2 = NULL;
  buffer2 = Calloc<long>(10, "");
  Free(&buffer2);

  char** buffer3 = NULL;
  buffer3 = Calloc<char *>(10, "");
  for (int i=0;i<10;i++)
    buffer3[i] = NULL;
  Free(&buffer3);
};

/**
 * UnitTest for ReAlloc()
 */
void MemoryAllocatorTest::ReAllocTest()
{
  int* buffer1 = NULL;
  buffer1 = Malloc<int>(1, "");
  buffer1 = ReAlloc<int>(buffer1, 2, "");
  Free(&buffer1);

  int* buffer2 = NULL;
  buffer2 = ReAlloc<int>(buffer2, 2, "");
  Free(&buffer2);
};

/**
 * UnitTest for Free()
 */
void MemoryAllocatorTest::FreeTest()
{
  char** buffer1 = NULL;
  Free(buffer1);

  int** buffer2 = NULL;
  Free(buffer2);
};


/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  // Get the top level suite from the registry
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

  // Adds the test to the list of test to run
  CppUnit::TextUi::TestRunner runner;
  runner.addTest( suite );

  // Change the default outputter to a compiler error format outputter
  runner.setOutputter( new CppUnit::CompilerOutputter( &runner.result(),
                                                       std::cerr ) );
  // Run the tests.
  bool wasSucessful = runner.run();

  // Return error code 1 if the one of test failed.
  return wasSucessful ? 0 : 1;
};
