/*
 * logunittest.cpp
 */


using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "logunittest.hpp"
#include "log.hpp"
#include "defs.hpp"
#include "verbose.hpp"

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( LogTest );


void LogTest::setUp()
{
};

void LogTest::tearDown()
{
};

/**
 * UnitTest for log()
 */
void LogTest::logTest()
{
  logger::getInstance()->setVerbosity(2);
  DoLog(0) && (Log() << Verbose(0) << "Verbosity level is set to 2." << endl);
  DoLog(0) && (Log() << Verbose(0) << "Test level 0" << endl);
  DoLog(1) && (Log() << Verbose(1) << "Test level 1" << endl);
  DoLog(2) && (Log() << Verbose(2) << "Test level 2" << endl);
  DoLog(3) && (Log() << Verbose(3) << "Test level 3" << endl);
  DoLog(4) && (Log() << Verbose(4) << "Test level 4" << endl);

  DoLog(0) && (Log() << Verbose(0) << "Output a log message." << endl);
  DoeLog(0) && (eLog()<< Verbose(0) << "Output an error message." << endl);
  setVerbosity(3);
  DoLog(4) && (Log() << Verbose(4) << "This should not be printed." << endl);
  DoeLog(4) && (eLog()<< Verbose(4) << "This should not be printed." << endl);
};


/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  // Get the top level suite from the registry
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

  // Adds the test to the list of test to run
  CppUnit::TextUi::TestRunner runner;
  runner.addTest( suite );

  // Change the default outputter to a compiler error format outputter
  runner.setOutputter( new CppUnit::CompilerOutputter( &runner.result(),
                                                       std::cerr ) );
  // Run the tests.
  bool wasSucessful = runner.run();

  // Return error code 1 if the one of test failed.
  return wasSucessful ? 0 : 1;
};
