/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * AtomTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include <Descriptors/AtomDescriptor.hpp>
#include <Descriptors/AtomIdDescriptor.hpp>
#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

TextDialog::AtomTextQuery::AtomTextQuery(Parameter<const atom *> &_param, const std::string &_title, const std::string &_description) :
    Dialog::TQuery<const atom *>(_param, _title,_description)
{}

TextDialog::AtomTextQuery::~AtomTextQuery() {}

bool TextDialog::AtomTextQuery::handle() {
  int idxOfAtom=-1;
  bool badInput = false;
  do{
    badInput = false;
    std::cout << getDescription() << ": ";
    std::cin >> idxOfAtom;
    if(std::cin.fail()){
      badInput = true;
      std::cin.clear();
      std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
      std::cout << "Input was not a number!" << std::endl;
      continue;
    }

    temp = const_cast<const World &>(World::getInstance()).getAtom(AtomById(idxOfAtom));
    if(!temp && idxOfAtom!=-1){
      std::cout << "Invalid Atom Index" << idxOfAtom << std::endl;
      badInput = true;
    }

  } while(badInput);
  std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
  return (idxOfAtom!=-1);
}


