/*
 * OutputAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/OutputAction.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char WorldOutputAction::NAME[] = "output";

WorldOutputAction::WorldOutputAction() :
  Action(NAME)
{}

WorldOutputAction::~WorldOutputAction()
{}

Action::state_ptr WorldOutputAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  string defaultname;

  defaultname = World::getInstance().getDefaultName();
  dialog->queryString(NAME, &defaultname, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    World::getInstance().setDefaultName(defaultname);
    DoLog(0) && (Log() << Verbose(0) << "Default name of new molecules set to " << World::getInstance().getDefaultName() << "." << endl);
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr WorldOutputAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldOutputAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldOutputAction::canUndo() {
  return false;
}

bool WorldOutputAction::shouldUndo() {
  return false;
}

const string WorldOutputAction::getName() {
  return NAME;
}
