/*
 * ManipulateAtomsProcess.cpp
 *
 *  Created on: Feb 18, 2010
 *      Author: crueger
 */

#include "ManipulateAtomsProcess.hpp"

#include <iostream>

using namespace std;

ManipulateAtomsProcess::ManipulateAtomsProcess(boost::function<void(atom*)> _operation, AtomDescriptor _descr,
                                               std::string _name,bool _doRegister) :
  Process(0,_name,_doRegister),
  descr(_descr),
  operation(_operation)
{}

ManipulateAtomsProcess::~ManipulateAtomsProcess()
{}

void ManipulateAtomsProcess::call(){
  World::get()->doManipulate(this);
}

void ManipulateAtomsProcess::undo(){

}

bool ManipulateAtomsProcess::canUndo(){
  return false;
}

void ManipulateAtomsProcess::doManipulate(World *world){
  setMaxSteps(world->numAtoms());
  start();
  World::AtomIterator iter;
  for(iter=world->getAtomIter(descr);iter!=world->atomEnd();++iter){
    setCurrStep(iter.getCount());
    operation(*iter);
  }
  stop();
}
