/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ParserTremolo_ElementKeysUnitTest.cpp
 *
 *  Created on: Mar 3, 2010
 *      Author: metzler
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ParserTremolo_ElementKeysUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Atom/atom.hpp"
#include "Descriptors/AtomTypeDescriptor.hpp"
#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "Parser/TremoloParser.hpp"
#include "Parser/TremoloParser_ElementKeys.hpp"
#include "Parser/ChangeTracker.hpp"
#include "World.hpp"
#include "WorldTime.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace std;

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ParserTremolo_ElementKeysUnitTest );
void ParserTremolo_ElementKeysUnitTest::setUp()
{
  knownTypes = new ElementKeys();
}

void ParserTremolo_ElementKeysUnitTest::tearDown()
{
  delete knownTypes;
}

/************************************ tests ***********************************/

void ParserTremolo_ElementKeysUnitTest::settergetterTest()
{
  // install a key
  CPPUNIT_ASSERT_NO_THROW( knownTypes->setType("H1", "H"));

  // check for excepetion
  CPPUNIT_ASSERT_THROW( knownTypes->setType("H1", "H"), IllegalParserKeyException);

  // get present key
  CPPUNIT_ASSERT_NO_THROW( knownTypes->getType("H1"));

  // get non-present key
  CPPUNIT_ASSERT_THROW( knownTypes->getType("F"), IllegalParserKeyException);
}
