/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */
/*
 * FactoryUnitTest.cpp
 *
 *  Created on: Jan 03, 2011
 *      Author: heber
 */
// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>
#include "Assert.hpp"

#include "FactoryUnitTest.hpp"

#include "stubs/CommonStub.hpp"
#include "stubs/FactoryStub.hpp"

#include <boost/nondet_random.hpp>
#include <boost/random.hpp>
#include <boost/random/additive_combine.hpp>
#include <boost/random/discard_block.hpp>
#include <boost/random/inversive_congruential.hpp>
#include <boost/random/lagged_fibonacci.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/linear_feedback_shift.hpp>
#include <boost/random/mersenne_twister.hpp>
#include <boost/random/random_number_generator.hpp>
#include <boost/random/ranlux.hpp>
#include <boost/random/shuffle_output.hpp>
#include <boost/random/subtract_with_carry.hpp>
#include <boost/random/xor_combine.hpp>
#include <boost/random/bernoulli_distribution.hpp>
#include <boost/random/binomial_distribution.hpp>
#include <boost/random/cauchy_distribution.hpp>
#include <boost/random/exponential_distribution.hpp>
#include <boost/random/gamma_distribution.hpp>
#include <boost/random/geometric_distribution.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/lognormal_distribution.hpp>
#include <boost/random/normal_distribution.hpp>
#include <boost/random/poisson_distribution.hpp>
#include <boost/random/triangle_distribution.hpp>
#include <boost/random/uniform_01.hpp>
#include <boost/random/uniform_int.hpp>
#include <boost/random/uniform_on_sphere.hpp>
#include <boost/random/uniform_real.hpp>
#include <boost/random/uniform_smallint.hpp>

#include <typeinfo>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( FactoryTest );

void FactoryTest::setUp()
{
  rndA =
      FactoryStub::getInstance().
      PrototypeTable[FactoryStub::Aclass]->create();
  rndB =
      FactoryStub::getInstance().
      PrototypeTable[FactoryStub::Bclass]->create();
  rndA_1 = NULL;
}

void FactoryTest::tearDown()
{
  delete rndA;
  delete rndB;
  delete rndA_1;
  FactoryStub::purgeInstance();
}

void FactoryTest::DistributionTest()
{
  // check the injectiveness of enum and string map
  for (FactoryStub::NameMap::const_iterator
      iter = FactoryStub::getInstance().names.begin();
      iter != FactoryStub::getInstance().names.end();
      ++iter) {
    CPPUNIT_ASSERT_EQUAL(
        iter->second,
        FactoryStub::getInstance().getName(
            FactoryStub::getInstance().getEnum(
                iter->second
            )
        )
    );
  }

  // check distributions in the table
  CPPUNIT_ASSERT_EQUAL(
      std::string(typeid(teststubs::Aclass).name()),
      rndA->name()
  );
  CPPUNIT_ASSERT_EQUAL(
      std::string(typeid(teststubs::Bclass).name()),
      rndB->name()
  );
}


void FactoryTest::getProductEnumTest()
{
  rndA_1 = FactoryStub::getInstance().getProduct(FactoryStub::Aclass);
  CPPUNIT_ASSERT( typeid(*rndA) == typeid(*rndA_1) );
}

void FactoryTest::getProductNameTest()
{
  rndA_1 = FactoryStub::getInstance().getProduct(std::string("Aclass"));
  CPPUNIT_ASSERT( typeid(*rndA) == typeid(*rndA_1) );
}

void FactoryTest::getProductTypeTest()
{
  rndA_1 = FactoryStub::getInstance().getProduct( typeid(teststubs::Aclass) );
  CPPUNIT_ASSERT( typeid(*rndA) == typeid(*rndA_1) );
}
