/*
 * AddAction.hpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#ifndef ADDACTION_HPP_
#define ADDACTION_HPP_

#include "Actions/Action.hpp"
#include "LinearAlgebra/Vector.hpp"

class element;

void AtomAdd(element *elemental, Vector &position);

class AtomAddAction : public Action {
  friend void AtomAdd(element *elemental, Vector &position);

public:
  AtomAddAction();
  virtual ~AtomAddAction();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();
protected:
  virtual Dialog * fillDialog(Dialog *);
private:
  virtual void getParametersfromValueStorage();
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  static const char NAME[];
};

#endif /* ADDACTION_HPP_ */
