/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * WorldStub.cpp
 *
 *  Created on: Dec 22, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "World.hpp"

#include "CodePatterns/Observer/Channels.hpp"
#include "CodePatterns/Observer/Notification.hpp"
#include "CodePatterns/Observer/ObservedContainer_impl.hpp"
#include "CodePatterns/Singleton_impl.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "Descriptors/AtomIdDescriptor_impl.hpp"

#include "IdPool_impl.hpp"

atom* World::_lastchangedatom = NULL;

AtomDescriptor::AtomDescriptor(impl_ptr ptr)
{}

AtomDescriptor::~AtomDescriptor()
{}

atom * AtomById(unsigned int i)
{
  return NULL;
}

World::World() :
    Observable("World"),
    atoms(this),
    selectedAtoms(this),
    atomIdPool(0, 20, 100),
    molecules(this),
    selectedMolecules(this),
    moleculeIdPool(0, 20,100)
{
  // observable stuff
  Channels *OurChannel = new Channels;
  Observable::insertNotificationChannel( std::make_pair(static_cast<Observable *>(this), OurChannel) );
  // add instance for each notification type
  OurChannel->addChannel(World::AtomInserted);
  OurChannel->addChannel(World::AtomRemoved);
}

World::~World()
{}

std::vector<const molecule *> World::getSelectedMolecules() const
{
  return std::vector<const molecule *>();
}

CONSTRUCT_SINGLETON(World);
