/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SaturatedFragmentUnitTest.cpp
 *
 *  Created on: Aug 09, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

// include headers that implement a archive in simple text format
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "SaturatedFragmentUnitTest.hpp"

#include <boost/assign.hpp>

#include "CodePatterns/Assert.hpp"

#include "Fragmentation/HydrogenSaturation_enum.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace boost::assign;

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( SaturatedFragmentTest );


void SaturatedFragmentTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

  SaturatedFragment::GlobalSaturationPositions_t globalpositions;
  set = new KeySet;
  fragment = new SaturatedFragment(
      *set,
      KeySetsInUse,
      hydrogens,
      ExcludeHydrogen,
      DoSaturate,
      globalpositions);
}


void SaturatedFragmentTest::tearDown()
{
  delete fragment;
  delete set;
}

/** UnitTest for getKeySet()
 */
void SaturatedFragmentTest::getKeySet_Test()
{
  CPPUNIT_ASSERT_EQUAL( *set, fragment->getKeySet() );
}
