/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AssertUnitTest.cpp
 *
 *  Created on: Feb 10, 2011
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "CodePatterns/Assert.hpp"

#include "AssertUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( AssertTest );

void testfunction() {
  ASSERT(0==1, "testfunction() - 0 != 1");
}

void testfunction2() {
  ASSERT(0==0, "testfunction() - 0 != 0");
}

void AssertTest::setUp()
{
  ASSERT_DO(Assert::Ignore);
};

void AssertTest::tearDown()
{};

/**
 * UnitTest for execeptions thrown by ASSERT()
 */
void AssertTest::ThrowTest()
{
  // test throw
  ASSERT_DO(Assert::Throw);
  CPPUNIT_ASSERT_THROW(testfunction(), Assert::AssertionFailure);
  CPPUNIT_ASSERT_NO_THROW(testfunction2());
  // test no throws on ignore (abort and others would interrupt unit test)
  ASSERT_DO(Assert::Ignore);
  CPPUNIT_ASSERT_NO_THROW(testfunction());
};
