/*
 * logger.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: metzler
 */

#ifndef LOGGER_HPP_
#define LOGGER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>

#include "CodePatterns/Singleton.hpp"

using namespace std;

class Verbose;

class logger : public Singleton<logger> {
  friend class Singleton<logger>;
public :
  static ostream *nix;
  static int verbosity;

  static bool DoOutput();
  static void setVerbosity(int verbosityLevel);
  static int getVerbosity();

protected:
  /** Do not call this constructor directly, use getInstance() instead. */
  logger();
  /** Do not call this destructor directly, use purgeInstance() instead. */
  ~logger();
};

ostream& operator<<(class logger&l, const Verbose& ost);
ostream& operator<<(class logger*l, const Verbose& ost);

#endif /* LOGGER_HPP_ */
