/*
 * enumerator.hpp
 *
 *  Created on: Dec 21, 2010
 *      Author: heber
 */

#ifndef ENUMERATOR_HPP_
#define ENUMERATOR_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <algorithm>
#include <map>

/************ struct to contain simple enumerations ***************/
template <class C>
struct enumeration{
  enumeration() : max(0) {}
  enumeration(unsigned int i) : max(i) {}
  enumeration(const enumeration &src) :
    there(src.there),
    back(src.back),
    max(src.max)
  {}
  enumeration &operator=(const enumeration &src){
    /* no self-assignment check needed */
    there = src.there;
    back = src.back;
    max = src.max;
    return *this;
  }
  void add(const C &value){
    if(!there.count(value)){
      there[value]=max;
      back[max++]=value;
    }
  }
  unsigned int getMax() const{
    return max;
  }

  std::map<C,unsigned int> there;
  std::map<unsigned int,C> back;
private:
  unsigned int max;
};

/***** A counter to generate sequential numbers *******************/
struct counter{
  inline counter() : count(0){};
  inline counter(int i) : count(i){};
  inline unsigned int operator()(){
    return count++;
  }
private:
  unsigned int count;
};

template <class C,class ForwardIterator>
enumeration<C> enumerate(ForwardIterator first,ForwardIterator last){
  enumeration<C> res;
  std::for_each(first,last,bind1st(mem_fun(&enumeration<C>::add),&res));
  return res;
}

#endif /* ENUMERATOR_HPP_ */
