/*
 * Factory_impl.hpp
 *
 *  Created on: Jan 3, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/preprocessor/debug/assert.hpp>
#include <boost/preprocessor/facilities/empty.hpp>
#include <boost/preprocessor/iteration/local.hpp>
#include <boost/preprocessor/punctuation/comma.hpp>
#include <boost/preprocessor/punctuation/comma_if.hpp>
#include <boost/preprocessor/punctuation/paren.hpp>
#include <boost/preprocessor/seq/elem.hpp>
#include <boost/preprocessor/seq/size.hpp>
#include <boost/preprocessor/stringize.hpp>

// check for required type_seq
#ifdef type_seq
#define type_seq_size BOOST_PP_SEQ_SIZE(type_seq)
#else
BOOST_PP_ASSERT_MSG( 0 , \
    "std::cout << \"missing type_seq for creating Factory<T>\" << std::endl")
#define type_seq ()
#endif

// check for required Abstract_Interface_Class
#ifndef Abstract_Interface_Class
    BOOST_PP_ASSERT_MSG( 0 , \
        "std::cout << \"missing Abstract_Interface_Class for creating Factory<T>\" << std::endl")
#define Abstract_Interface_Class NONE
#endif

// check for required Abstract_Encapsulation_Class
#ifndef Abstract_Encapsulation_Class
    BOOST_PP_ASSERT_MSG( 0 , \
        "std::cout << \"missing Abstract_Encapsulation_Class for creating Factory<T>\" << std::endl")
#define Abstract_Encapsulation_Class NONE
#endif

// check for type_name_space, is only optional
#ifndef type_name_space
#define type_name_space BOOST_PP_EMPTY()
#endif

#ifndef type_name_space_suffix
#define type_name_space_suffix BOOST_PP_EMPTY()
#endif


/** Functions that allows to print a given seq of elements in the way of
 *  std::map from strings to enums.
 *
 * e.g. let "seq" be defined as
 * #define seq (one)(two)(three)(four)
 *
 * then we use
 * #define BOOST_PP_LOCAL_MACRO(n) seqitems_as_enum_key_map(seqsize, n, seq, EnumMap, test::)
 * #define BOOST_PP_LOCAL_LIMITS  (0, BOOST_PP_SEQ_SIZE(seq)-1 )
 * #include BOOST_PP_LOCAL_ITERATE()
 *
 * which expands by the preprocessor to:
 * EnumMap[one] = test::one;
 * EnumMap[two] = test::two;
 * EnumMap[three] = test::three;
 * EnumMap[four] = test::four;
 *
 */
#define seqitems_as_enum_key_map(z,n,_seq_with_elements, _map, _keytype, _key_name_space, _type_name_space, _type_suffix) \
  _map [ _key_name_space \
  BOOST_PP_SEQ_ELEM(n, _seq_with_elements) \
  ] = _keytype< _type_name_space BOOST_PP_SEQ_ELEM(n, _seq_with_elements) _type_suffix > ();

/** Functions that allows to print a given seq of elements in the way of
 *  std::map from strings to enums.
 *
 * e.g. let "seq" be defined as
 * #define seq (one)(two)(three)(four)
 *
 * then we use
 * #define BOOST_PP_LOCAL_MACRO(n) seqitems_as_enum_value_map(seqsize, n, seq, EnumMap, typid BOOST_PP_LPAREN() super:: , BOOST_PP_RPAREN().name() , test::)
 * #define BOOST_PP_LOCAL_LIMITS  (0, BOOST_PP_SEQ_SIZE(seq)-1 )
 * #include BOOST_PP_LOCAL_ITERATE()
 *
 * which expands by the preprocessor to:
 * EnumMap[ typeid ( super:: one ) .name() ] = test::one;
 * EnumMap[ typeid ( super:: two ) .name() ] = test::two;
 * EnumMap[ typeid ( super:: three ) .name() ] = test::three;
 * EnumMap[ typeid ( super:: four ) .name() ] = test::four;
 *
 * or we use
 * #define BOOST_PP_LOCAL_MACRO(n) seqitems_as_enum_value_map(seqsize, n, seq, EnumMap, BOOST_PP_STRINGIZE BOOST_PP_LPAREN() , BOOST_PP_RPAREN() , test::)
 * #define BOOST_PP_LOCAL_LIMITS  (0, BOOST_PP_SEQ_SIZE(seq)-1 )
 * #include BOOST_PP_LOCAL_ITERATE()
 *
 * which expands by the preprocessor to:
 * EnumMap[ "one" ] = test:: one;
 * EnumMap[ "two" ] = test:: two;
 * EnumMap[ "three" ] = test:: three;
 * EnumMap[ "four" ] = test:: four;
 */
#define seqitems_as_enum_value_map(z,n,_seq_with_elements, _map, _type_specifier, _type_suffix, _enum_name_space) \
  _map [ _type_specifier  \
  BOOST_PP_SEQ_ELEM(n, _seq_with_elements) \
  _type_suffix \
  ] = _enum_name_space BOOST_PP_SEQ_ELEM(n, _seq_with_elements);


template <>
void Factory<Abstract_Interface_Class>::FillEnumTable()
{
  // insert all known (enum, string) keys
#define BOOST_PP_LOCAL_MACRO(n) seqitems_as_enum_value_map(~, n, type_seq, enums, BOOST_PP_STRINGIZE BOOST_PP_LPAREN() , BOOST_PP_RPAREN() , FactoryTypeList<Abstract_Interface_Class>::)
#define BOOST_PP_LOCAL_LIMITS  (0, BOOST_PP_SEQ_SIZE(type_seq)-1 )
#include BOOST_PP_LOCAL_ITERATE()

  // insert all known (type, enum) keys
#define BOOST_PP_LOCAL_MACRO(n) seqitems_as_enum_value_map(~, n, type_seq, types, typeid BOOST_PP_LPAREN() type_name_space , type_name_space_suffix BOOST_PP_RPAREN() .name(), FactoryTypeList<Abstract_Interface_Class>::)
#define BOOST_PP_LOCAL_LIMITS  (0, BOOST_PP_SEQ_SIZE(type_seq)-1 )
#include BOOST_PP_LOCAL_ITERATE()

  // create invert mapping (string, enum)
  for (Factory<Abstract_Interface_Class>::EnumMap::const_iterator iter = enums.begin();
      iter != enums.end();
      ++iter) {
    names.insert(make_pair(iter->second, iter->first));
  }
}

template <>
void Factory<Abstract_Interface_Class>::FillPrototypeTable()
{
  // fill PrototypeTable
#define BOOST_PP_LOCAL_MACRO(n) seqitems_as_enum_key_map(~, n, type_seq, PrototypeTable, new Creator< Abstract_Interface_Class BOOST_PP_COMMA() Abstract_Encapsulation_Class, FactoryTypeList<Abstract_Interface_Class>::, type_name_space, type_name_space_suffix > )
#define BOOST_PP_LOCAL_LIMITS  (0, BOOST_PP_SEQ_SIZE(type_seq)-1 )
#include BOOST_PP_LOCAL_ITERATE()
}

