/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * LinkedCell_ModelStub.cpp
 *
 *  Created on: Nov 29, 2011
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "LinkedCell/LinkedCell_Model.hpp"

#include <algorithm>
#include <boost/multi_array.hpp>
#include <limits>

#include "Box.hpp"
#include "LinkedCell/types.hpp"

#include "LinkedCell/LinkedCell_Model_inline.hpp"

// initialize static entities
LinkedCell::tripleIndex LinkedCell::LinkedCell_Model::NearestNeighbors;

/** Constructor of LinkedCell_Model stub.
 *
 * @param radius desired maximum neighborhood distance
 * @param _domain Box instance with domain size and boundary conditions
 */
LinkedCell::LinkedCell_Model::LinkedCell_Model(const double radius, const Box &_domain) :
    internal_Sizes(NULL),
    domain(_domain)
{
}


/** Destructor of class LinkedCell_Model stub.
 *
 */
LinkedCell::LinkedCell_Model::~LinkedCell_Model()
{
}
