/*
 * element.hpp
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef ELEMENT_HPP_
#define ELEMENT_HPP_

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <string>

#include "defs.hpp"
#include "types.hpp"

/********************************************** declarations *******************************/

/** Chemical element.
 * Class incorporates data for a certain chemical element to be referenced from atom class.
 */
class element {
  public:
    double mass;    //!< mass in g/mol
    double CovalentRadius;  //!< covalent radius
    double VanDerWaalsRadius;  //!< can-der-Waals radius
    int Z;          //!< atomic number
    char name[64];  //!< atom name, i.e. "Hydrogren"
    char symbol[3]; //!< short form of the atom, i.e. "H"
    char period[8];    //!< period: n quantum number
    char group[8];    //!< group: l quantum number
    char block[8];    //!< block: l quantum number
    element *previous;  //!< previous item in list
    element *next;  //!< next element in list
    int *sort;      //!< sorc criteria
    int No;         //!< number of element set on periodentafel::Output()
    double Valence;   //!< number of valence electrons for this element
    int NoValenceOrbitals;  //!< number of valence orbitals, used for determining bond degree in molecule::CreateConnectmatrix()
    double HBondDistance[NDIM]; //!< distance in Angstrom of this element to hydrogen  (for single, double and triple bonds)
    double HBondAngle[NDIM];     //!< typical angle for one, two, three bonded hydrogen (in degrees)

  element();
  ~element();

  // accessor functions
  atomicNumber_t getNumber() const;
  std::string getSymbol() const;

  //> print element entries to screen
  bool Output(std::ostream * const out) const;
  bool Checkout(std::ostream * const out, const int No, const int NoOfAtoms) const;

  private:
};


#endif /* ELEMENT_HPP_ */
