/*
 * ActionRegistry.hpp
 *
 *  Created on: Jan 7, 2010
 *      Author: crueger
 */

#ifndef ACTIONREGISTRY_HPP_
#define ACTIONREGISTRY_HPP_

#include <iosfwd>
#include <string>
#include <map>

#include "Patterns/Singleton.hpp"

class Action;

class ActionRegistry : public Singleton<ActionRegistry>
{
  friend class Singleton<ActionRegistry>;
public:
  Action* getActionByName(const std::string);
  bool isActionByNamePresent(const std::string name);
  void registerAction(Action*);
  void unregisterAction(Action*);

  std::map<const std::string,Action*>::iterator getBeginIter();
  std::map<const std::string,Action*>::const_iterator getBeginIter() const;
  std::map<const std::string,Action*>::iterator getEndIter();
  std::map<const std::string,Action*>::const_iterator getEndIter() const;

private:
  std::map<const std::string,Action*> actionMap;

private:
  ActionRegistry();
  virtual ~ActionRegistry();
};

std::ostream& operator<<(std::ostream& ost, const ActionRegistry& m);

#endif /* ACTIONREGISTRY_HPP_ */
