/*
 * XyzParser.cpp
 *
 *  Created on: Mar 2, 2010
 *      Author: metzler
 */

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "XyzParser.hpp"
#include "World.hpp"
#include "atom.hpp"
#include "molecule.hpp"
#include "element.hpp"
#include "periodentafel.hpp"

using namespace std;

/**
 * Constructor.
 */
XyzParser::XyzParser() :
  comment("")
{}

/**
 * Destructor.
 */
XyzParser::~XyzParser() {
}

/**
 * Loads an XYZ file into the World.
 *
 * \param XYZ file
 */
void XyzParser::load(istream* file) {
  atom* newAtom = NULL;
  molecule* newmol = NULL;
  int numberOfAtoms;
  char commentBuffer[512], type[3];
  double tmp;

  // the first line tells number of atoms, the second line is always a comment
  *file >> numberOfAtoms >> ws;
  file->getline(commentBuffer, 512);
  comment = commentBuffer;

  newmol = World::getInstance().createMolecule();
  newmol->ActiveFlag = true;
  World::getInstance().getMolecules()->insert(newmol);
  for (int i = 0; i < numberOfAtoms; i++) {
    newAtom = World::getInstance().createAtom();
    *file >> type;
    for (int j=0;j<NDIM;j++) {
      *file >> tmp;
      newAtom->set(j, tmp);
    }
    newAtom->setType(World::getInstance().getPeriode()->FindElement(type));
    newmol->AddAtom(newAtom);
  }
}

/**
 * Saves the current state of the World into the given XYZ file.
 *
 * \param XYZ file
 */
void XyzParser::save(ostream* file) {
  DoLog(0) && (Log() << Verbose(0) << "Saving changes to xyz." << std::endl);
  if (comment == "") {
    time_t now = time((time_t *)NULL);   // Get the system time and put it into 'now' as 'calender time'
    comment = "Created by molecuilder on ";
    // ctime ends in \n\0, we have to cut away the newline
    std::string time(ctime(&now));
    size_t pos = time.find('\n');
    if (pos != 0)
      comment += time.substr(0,pos);
    else
      comment += time;
  }
  *file << World::getInstance().numAtoms() << endl << "\t" << comment << endl;

  vector<atom*> atoms = World::getInstance().getAllAtoms();
  for(vector<atom*>::iterator it = atoms.begin(); it != atoms.end(); it++) {
    *file << noshowpoint << (*it)->getType()->symbol << "\t" << (*it)->at(0) << "\t" << (*it)->at(1) << "\t" << (*it)->at(2) << endl;
  }
}
