/*
 * PcpParser.hpp
 *
 *  Created on: 12.06.2010
 *      Author: heber
 */

#ifndef PCPPARSER_HPP_
#define PCPPARSER_HPP_

#include <iosfwd>
#include "Parser/FormatParser.hpp"

/**
 * Parser for PCP config files.
 */
class PcpParser : public FormatParser {
public:
  PcpParser();
  ~PcpParser();
  void load(std::istream* file);
  void save(std::ostream* file);

  bool operator==(const PcpParser& b) const;

private:

  void ParseThermostats(class ConfigFileBuffer * const fb);
  void OutputAtoms(ostream *file, vector<atom *> &allatoms, map<int, int> &ZtoIndexMap);
  void OutputElements(ostream *file, vector<atom *> &allatoms, map<int, int> &ZtoIndexMap);
  void CalculateOrbitals(vector<atom *> &allatoms);

  class StructParallelization {
  public:
    StructParallelization();
    ~StructParallelization();

    int ProcPEGamma;
    int ProcPEPsi;
  } Parallelization;

  /*
   * Contains all the paths and names
   */
  class StructPaths {
  public:
    StructPaths();
    ~StructPaths();

    char *databasepath;
    char *configname;
    char *mainname;
    char *defaultpath;
    char *pseudopotpath;
  } Paths;

  /*
   * Contains all Do/Don't switches
   */
  class StructSwitches {
  public:
    StructSwitches();
    ~StructSwitches();

    int DoConstrainedMD;
    int DoOutVis;
    int DoOutMes;
    int DoOutNICS;
    int DoOutOrbitals;
    int DoOutCurrent;
    int DoFullCurrent;
    int DoPerturbation;
    int DoWannier;
  } Switches;

  /*
   * Contains parameters regarding localization of orbitals or magnetic perturbation
   */
  class StructLocalizedOrbitals {
  public:
    StructLocalizedOrbitals();
    ~StructLocalizedOrbitals();

    int CommonWannier;
    double SawtoothStart;
    int VectorPlane;
    double VectorCut;
    int UseAddGramSch;
    int Seed;
    double EpsWannier;
  } LocalizedOrbitals;

  /*
   * Contains all step count and other epsilon threshold parameters
   */
  class StructStepCounts {
  public:
    StructStepCounts();
    ~StructStepCounts();

    int MaxMinStopStep;
    int InitMaxMinStopStep;

    int OutVisStep;
    int OutSrcStep;
    int MaxPsiStep;

    int MaxOuterStep;

    int MaxMinStep;
    double RelEpsTotalEnergy;
    double RelEpsKineticEnergy;
    int MaxMinGapStopStep;
    int MaxInitMinStep;
    double InitRelEpsTotalEnergy;
    double InitRelEpsKineticEnergy;
    int InitMaxMinGapStopStep;
  } StepCounts;

  /*
   * Contains all parameters specific to the plane wave basis set
   */
  class StructPlaneWaveSpecifics {
  public:
    StructPlaneWaveSpecifics();
    ~StructPlaneWaveSpecifics();

    int PsiType;
    int MaxPsiDouble;
    int PsiMaxNoUp;
    int PsiMaxNoDown;
    double ECut;
    int MaxLevel;
    int RiemannTensor;
    int LevRFactor;
    int RiemannLevel;
    int Lev0Factor;
    int RTActualUse;
    int AddPsis;
    double RCut;
  } PlaneWaveSpecifics;

  bool FastParsing;

  double Deltat;
  int IsAngstroem;
  int RelativeCoord;
  int StructOpt;
  int MaxTypes;
  string basis;
};

#endif /* PCPPARSER_HPP_ */
