/*
 * FormatParser.cpp
 *
 *  Created on: Mar 1, 2010
 *      Author: metzler
 */

#include "Helpers/MemDebug.hpp"

#include "FormatParser.hpp"
#include <iostream>

using namespace std;

/**
 * Constructor.
 */
FormatParser::FormatParser() :
  Observer("FormatParser"),
  saveStream(NULL)
{
  ChangeTracker::getInstance().signOn(this);
}

/**
 * Destructor.
 */
FormatParser::~FormatParser() {
  ChangeTracker::getInstance().signOff(this);
}

/**
 * Update operation which can be invoked by the observable (which should be the
 * change tracker here).
 */
void FormatParser::update(Observable *publisher) {
  if (!saveStream) {
    cerr << "Please invoke setOstream() so the parser knows where to save the World's data." << endl;
    return;
  }

  save(saveStream);
}

/**
 * The observable can tell when it dies.
 */
void FormatParser::subjectKilled(Observable *publisher) {}


/**
 * Sets the output stream for save, so the save() method can be invoked on update
 * automatically.
 *
 * \param ostream where to save the World's state
 */
void FormatParser::setOstream(ostream* output) {
  saveStream = output;
}
