/*
 * SamplingGridPropertiesProperties_inline.hpp
 *
 *  Created on: 12.05.2013
 *      Author: heber
 */

#ifndef SAMPLINGGRIDPROPERTIES_INLINE_HPP_
#define SAMPLINGGRIDPROPERTIES_INLINE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SamplingGridProperties.hpp"

#include <cmath>

#ifdef HAVE_INLINE
inline
#endif
const double SamplingGridProperties::getVolume() const
{
  double volume = 1.;
  for (size_t i=0;i<NDIM;++i)
    volume *= end[i]-begin[i];
  return volume;
}

#ifdef HAVE_INLINE
inline
#endif
const size_t SamplingGridProperties::getTotalGridPoints() const
{
  return pow(getGridPointsPerAxis(),(int)NDIM);
}

#ifdef HAVE_INLINE
inline
#endif
const size_t SamplingGridProperties::getGridPointsPerAxis() const
{
  static size_t s_gridpoints = 1;
  static int s_level = 0;
  if (s_level != level) {
    s_gridpoints = 1 << level;
    s_level = level;
  }
  return s_gridpoints;
}

#ifdef HAVE_INLINE
inline
#endif
const double SamplingGridProperties::getDeltaPerAxis(const size_t axis) const
{
  return getTotalLengthPerAxis(axis)/(double)getGridPointsPerAxis();
}

#ifdef HAVE_INLINE
inline
#endif
const double SamplingGridProperties::getTotalLengthPerAxis(const size_t axis) const
{
  return (end[axis] - begin[axis]);
}

#endif /* SAMPLINGGRIDPROPERTIES_INLINE_HPP_ */
