/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * CacheableUnitTest.cpp
 *
 *  Created on: Feb 2, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CacheableUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <boost/bind.hpp>

#include "CodePatterns/Cacheable.hpp"

#include "stubs/Cacheable_threeNumbers.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( CacheableTest );

void CacheableTest::setUp(){
  numbers = new Cacheable_threeNumbers(1,2,3);
  Observable::channels_t ychannel(1, Cacheable_threeNumbers::YChanged);
  YChange_numbers = new Cacheable_threeNumbers(1,2,3, ychannel);
}

void CacheableTest::tearDown(){
  delete numbers;
}

void CacheableTest::doesRecalcTest()
{
  CPPUNIT_ASSERT_EQUAL( 6, *(numbers->sum));
  CPPUNIT_ASSERT_EQUAL( true, numbers->hasRecalced);
  numbers->hasRecalced=false;
  numbers->setX(4);
  CPPUNIT_ASSERT_EQUAL( false, numbers->hasRecalced);
  CPPUNIT_ASSERT_EQUAL( 9, *(numbers->sum));
  CPPUNIT_ASSERT_EQUAL( true, numbers->hasRecalced);
  numbers->hasRecalced=false;
  CPPUNIT_ASSERT_EQUAL( 9, *(numbers->sum));
#ifndef NO_CACHING
  CPPUNIT_ASSERT_EQUAL( false, numbers->hasRecalced);
#else
  CPPUNIT_ASSERT_EQUAL( true, numbers->hasRecalced);
#endif

  CPPUNIT_ASSERT_EQUAL( 6, *(YChange_numbers->sum));
  CPPUNIT_ASSERT_EQUAL( true, YChange_numbers->hasRecalced);
  YChange_numbers->hasRecalced=false;
  YChange_numbers->setX(4);
  CPPUNIT_ASSERT_EQUAL( false, YChange_numbers->hasRecalced);
  CPPUNIT_ASSERT_EQUAL( 6, *(YChange_numbers->sum));
  CPPUNIT_ASSERT_EQUAL( false, YChange_numbers->hasRecalced);
  YChange_numbers->hasRecalced=false;
  YChange_numbers->setY(4);
  CPPUNIT_ASSERT_EQUAL( false, YChange_numbers->hasRecalced);
  CPPUNIT_ASSERT_EQUAL( 11, *(YChange_numbers->sum));
  CPPUNIT_ASSERT_EQUAL( true, YChange_numbers->hasRecalced);
  YChange_numbers->hasRecalced=false;
  CPPUNIT_ASSERT_EQUAL( 11, *(YChange_numbers->sum));
#ifndef NO_CACHING
  CPPUNIT_ASSERT_EQUAL( false, YChange_numbers->hasRecalced);
#else
  CPPUNIT_ASSERT_EQUAL( true, YChange_numbers->hasRecalced);
#endif
}
