/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Thermostat.cpp
 *
 *  Created on: Aug 18, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Thermostat.hpp"

#include "CodePatterns/Assert.hpp"

Thermostat::Thermostat() :
  container(0)
{}

Thermostat::~Thermostat()
{}

const char *ThermostatTraits<Thermostat>::name = "Base";

std::string ThermostatTraits<Thermostat>::getName(){
  return ThermostatTraits<Thermostat>::name;
}

void Thermostat::addToContainer(ThermoStatContainer *_container){
  container = _container;
}

ThermoStatContainer &Thermostat::getContainer(){
  ASSERT(container,"No container used for this Thermostat");
  return *container;
}
