/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * NoThermostat.cpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "NoThermostat.hpp"

NoThermostat::NoThermostat()
{}

NoThermostat::~NoThermostat()
{}

const char *ThermostatTraits<NoThermostat>::name = "None";

std::string ThermostatTraits<NoThermostat>::getName(){
  return ThermostatTraits<NoThermostat>::name;
}

Thermostat *ThermostatTraits<NoThermostat>::make(class ConfigFileBuffer * const fb){
  return new NoThermostat();
}

double NoThermostat::scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::list) atoms){
  return 0;
}

double NoThermostat::scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::vector) atoms){
  return 0;
}

double NoThermostat::scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::set) atoms){
  return 0;
}

std::string NoThermostat::name(){
  return ThermostatTraits<NoThermostat>::name;
}

std::string NoThermostat::writeParams(){
  return "";
}
