/*
 * BoostGraphCreatorUnitTest.hpp
 *
 *  Created on: May 19, 2017
 *      Author: heber
 */

#ifndef BOOSTGRAPHCREATORUNITTEST_HPP_
#define BOOSTGRAPHCREATORUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

class BoostGraphCreator;

/********************************************** Test classes **************************************/

class BoostGraphCreatorTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( BoostGraphCreatorTest) ;
    CPPUNIT_TEST ( SetupTest );
    CPPUNIT_TEST ( createFromRangeTest );
    CPPUNIT_TEST ( createFromMoleculeTest );
    CPPUNIT_TEST ( createFromAtomsTest );
    CPPUNIT_TEST ( addremoveEdgeTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void SetupTest();
      void createFromRangeTest();
      void createFromMoleculeTest();
      void createFromAtomsTest();
      void addremoveEdgeTest();

private:
      BoostGraphCreator *BGCreator;

      molecule *TestMolecule;
      const element *hydrogen;
      const element *carbon;
};

#endif /* BOOSTGRAPHCREATORUNITTEST_HPP_ */
