/*
 * CyclicStructureAnalysis.hpp
 *
 *  Created on: Feb 16, 2011
 *      Author: heber
 */

#ifndef CYCLICSTRUCTUREANALYSIS_HPP_
#define CYCLICSTRUCTUREANALYSIS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <deque>
#include <map>

#include "Bond/bond.hpp"
#include "Bond/GraphEdge.hpp"
#include "Fragmentation/HydrogenSaturation_enum.hpp"
#include "Helpers/defs.hpp"
#include "types.hpp"

class atom;
class molecule;

class CyclicStructureAnalysis
{
public:
  explicit CyclicStructureAnalysis(const enum HydrogenTreatment _treatment);
  ~CyclicStructureAnalysis();

  void Reset();
  void operator()(std::deque<bond::ptr > * BackEdgeStack);

  const std::map<atomId_t, int >& getMinimumRingSize() const;

private:
  // init or reset
  void InitNode(atomId_t atom_id);
  void CleanAllTouched();
  void InitializeToRoot(atom *&Walker);
  // performing tasks
  void CyclicBFSFromRootToRoot(bond::ptr &BackEdge);
  void RetrieveCycleMembers(atom *&OtherAtom, bond::ptr &BackEdge, int &MinRingSize);
  void BFSToNextCycle(atom *&Root, atom *&Walker);
  void AssignRingSizetoNonCycleMembers(int &MinRingSize, int &NumCycles);
  // output
  void OutputAlreadyVisited(int *list);

  std::map<atomId_t, atom *> PredecessorList;
  std::map<atomId_t, int > ShortestPathList;
  std::map<atomId_t, enum GraphEdge::Shading> ColorList;
  std::map<atomId_t, int > MinimumRingSize;
  std::deque<atom *> BFSStack;
  std::deque<atom *> TouchedStack;
  int BondOrder;
  atom *Root;

  //!> whether to treat hydrogen special or not
  const enum HydrogenTreatment treatment;

  bool BackStepping;
  int CurrentGraphNr;
  int ComponentNr;
};

#endif /* CYCLICSTRUCTUREANALYSIS_HPP_ */
