/*
 * PowerSetGenerator.hpp
 *
 *  Created on: Oct 18, 2011
 *      Author: heber
 */

#ifndef POWERSETGENERATOR_HPP_
#define POWERSETGENERATOR_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <list>
#include <vector>

#include "Bond/bond.hpp"
#include "Fragmentation/BondsPerShortestPath.hpp"
#include "Fragmentation/HydrogenSaturation_enum.hpp"

class UniqueFragments;

class PowerSetGenerator
{
public:
  PowerSetGenerator(UniqueFragments *_FragmentSearch, int _Order);
  ~PowerSetGenerator();

  void SPFragmentGenerator(int RootDistance, std::vector<bond::ptr > &BondsSet, int SetDimension, int SubOrder);
  int operator()(KeySet &RestrictedKeySet, const enum HydrogenTreatment treatment);
  void RemoveAllTouchedFromSnakeStack(int verbosity, KeySet *FragmentSet, int *&TouchedList, int &TouchedIndex);
  int FillBondsList(std::vector<bond::ptr > &BondsList, std::list<bond::ptr >::const_iterator SetFirst, std::list<bond::ptr >::const_iterator SetLast, int *&TouchedList, int TouchedIndex);
  int CountSetMembers(std::list<bond::ptr >::const_iterator SetFirst, std::list<bond::ptr >::const_iterator SetLast, int *&TouchedList, int TouchedIndex);
  int AddPowersetToSnakeStack(int verbosity, int CurrentCombination, int SetDimension, KeySet *FragmentSet, std::vector<bond::ptr > &BondsSet, int *&TouchedList, int &TouchedIndex);
  void ClearingTouched(int verbosity, int *&TouchedList, int SubOrder, int &TouchedIndex);

private:
  int countBits(const int bits, const int SetDimension) const;

  BondsPerShortestPath BondsPerSPList;
  UniqueFragments *FragmentSearch;
};

#ifdef HAVE_INLINE
inline
#endif
int PowerSetGenerator::countBits(const int i, const int SetDimension) const
{
  int bits = 0;
  for (int j=SetDimension;j--;)
    bits += (i & (1 << j)) >> j;
  return bits;
}


#endif /* POWERSETGENERATOR_HPP_ */
