/*
 * HydrogenSaturation_enum.hpp
 *
 *  Created on: Oct 26, 2011
 *      Author: heber
 */

#ifndef HYDROGENSATURATION_ENUM_HPP_
#define HYDROGENSATURATION_ENUM_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

enum HydrogenSaturation {
  DontSaturate, //!< don't saturate and don't treat hydrogen special in any way
  DoSaturate,   //!< do saturate dangling bonds and hence also treat hydrogen special (neglect it)
};

enum HydrogenTreatment {
  ExcludeHydrogen, //!< exclude hydrogen from the bond graph, i.e. fragmentation treats hydrogen special
  IncludeHydrogen,   //!< include hydrogen from the bond graph, i.e. fragmentation treats hydrogen just as the rest
};


#endif /* HYDROGENSATURATION_ENUM_HPP_ */
