/*
 * BondsPerShortestPath.hpp
 *
 *  Created on: Oct 18, 2011
 *      Author: heber
 */

#ifndef BONDSPERSHORTESTPATH_HPP_
#define BONDSPERSHORTESTPATH_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Bond/bond.hpp"
#include "Fragmentation/HydrogenSaturation_enum.hpp"

#include <list>
#include <vector>

class atom;
class KeySet;

class BondsPerShortestPath
{
public:
  explicit BondsPerShortestPath(int _Order);
  ~BondsPerShortestPath();

  void InitialiseSPList();
  void FreeSPList();
  void SetSPList(atom *_Root);
  void ResetSPList();
  void FillSPListandLabelVertices(int _RootKeyNr, KeySet &RestrictedKeySet, const enum HydrogenTreatment treatment);
  void OutputSPList();
  int CountNumbersInBondsList();

  int getOrder() const;

  typedef std::list<bond::ptr> BondsPerSP;
  typedef std::vector< BondsPerSP > AllSPBonds;

  int *BondsPerSPCount;
  AllSPBonds BondsPerSPList;

private:
  //!> bond order (limits BFS exploration and "number of digits" in power set generation
  int Order;
};

/** Getter for BondsPerShortestPath::Order.
 *
 * @return returns BondsPerShortestPath::Order
 */
#ifdef HAVE_INLINE
inline
#endif
int BondsPerShortestPath::getOrder() const
{
  return Order;
}


#endif /* BONDSPERSHORTESTPATH_HPP_ */
