/*
 * DiscreteValidator.hpp
 *
 *  Created on: Apr 13, 2012
 *      Author: ankele
 */

#ifndef DISCRETEVALIDATOR_HPP_
#define DISCRETEVALIDATOR_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/** A validator with a discrete list of valid values.
 *
 */
template <class T>
class DiscreteValidator : public Validator
{
public:
  DiscreteValidator(const std::vector<T> &_ValidValues)
  virtual ~DiscreteValidator() {};

  bool isValid(const T & _value)
  {
    typename std::vector<T>::const_iterator iter = std::find(ValidValues.begin(), ValidValues.end(), _value);
    if (iter != ValidValues.end()) {
      //std::cout << "Found " << _value << ":" << *iter << std::endl;
      return true;
    } else {
      //std::cout << "Did not find " << _value << "." << std::endl;
      return false;
    }
  }

private:
  //!> list of valid values
  std::vector<T> ValidValues;
};


#endif /* DISCRETEVALIDATOR_HPP_ */
