/*
 * ShapeRegistry.hpp
 *
 *  Created on: Sep 13, 2012
 *      Author: ankele
 */

#ifndef SHAPEREGISTRY_HPP_
#define SHAPEREGISTRY_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Observer/Observable.hpp"
#include "CodePatterns/Registry.hpp"
#include "CodePatterns/Singleton.hpp"

#include "Shape.hpp"

class ShapeRegistry : public Singleton<ShapeRegistry>, public Registry<Shape>, public Observable
{
  friend class Singleton<ShapeRegistry>;

public:
  void addShape(Shape s);
  Shape* getShapeByName(const std::string name);
  bool isShapePresentByName(const std::string name) const;

  enum NotificationType {
    ShapeInserted,
    ShapeRemoved,
    SelectionChanged,
    NotificationType_MAX
  };

private:
  // private constructor and destructor due to singleton
  ShapeRegistry();
  virtual ~ShapeRegistry();

};

#endif /* SHAPEREGISTRY_HPP_ */
