/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ShapeRegistry.cpp
 *
 *  Created on: Sep 13, 2012
 *      Author: ankele
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "ShapeRegistry.hpp"

#include "CodePatterns/Singleton_impl.hpp"
#include "CodePatterns/Registry_impl.hpp"
#include "CodePatterns/Observer/Channels.hpp"

ShapeRegistry::ShapeRegistry() :
  Observable::Observable("ShapeRegistry")
{
  Channels *OurChannel = new Channels;
  NotificationChannels.insert( std::make_pair(this, OurChannel) );
  // add instance for each notification type
  for (size_t type = 0; type < NotificationType_MAX; ++type)
    OurChannel->addChannel(type);
}

ShapeRegistry::~ShapeRegistry()
{
  cleanup();
}

void ShapeRegistry::addShape(Shape s)
{
  OBSERVE;
  Shape *instance = new Shape(s);
  registerInstance(instance);
  NOTIFY(ShapeInserted);
}

CONSTRUCT_SINGLETON(ShapeRegistry)
CONSTRUCT_REGISTRY(Shape)
