/*
 * PairCorrelationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AnalysisAction/PairCorrelationAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "analysis_correlation.hpp"
#include "boundary.hpp"
#include "linkedcell.hpp"
#include "Helpers/Verbose.hpp"
#include "Helpers/Log.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

const char AnalysisPairCorrelationAction::NAME[] = "pair-correlation";

AnalysisPairCorrelationAction::AnalysisPairCorrelationAction() :
  Action(NAME)
{}

AnalysisPairCorrelationAction::~AnalysisPairCorrelationAction()
{}

void AnalysisPairCorrelation(std::vector< element *> &elements, double BinStart, double BinWidth, double BinEnd, string &outputname, string &binoutputname, bool periodic) {
  ValueStorage::getInstance().setCurrentValue("elements", elements);
  ValueStorage::getInstance().setCurrentValue("bin-start", BinStart);
  ValueStorage::getInstance().setCurrentValue("bin-width", BinWidth);
  ValueStorage::getInstance().setCurrentValue("bin-end", BinEnd);
  ValueStorage::getInstance().setCurrentValue("output-file", outputname);
  ValueStorage::getInstance().setCurrentValue("bin-output-file", binoutputname);
  ValueStorage::getInstance().setCurrentValue("periodic", periodic);
  ActionRegistry::getInstance().getActionByName(AnalysisPairCorrelationAction::NAME)->call(Action::NonInteractive);
};


Dialog* AnalysisPairCorrelationAction::fillDialog(Dialog* dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryElements("elements", ValueStorage::getInstance().getDescription("elements"));
  dialog->queryDouble("bin-start", ValueStorage::getInstance().getDescription("bin-start"));
  dialog->queryDouble("bin-width", ValueStorage::getInstance().getDescription("bin-width"));
  dialog->queryDouble("bin-end", ValueStorage::getInstance().getDescription("bin-end"));
  dialog->queryString("output-file", ValueStorage::getInstance().getDescription("output-file"));
  dialog->queryString("bin-output-file", ValueStorage::getInstance().getDescription("bin-output-file"));
  dialog->queryBoolean("periodic", ValueStorage::getInstance().getDescription("periodic"));

  return dialog;
}

Action::state_ptr AnalysisPairCorrelationAction::performCall() {
  int ranges[3] = {1, 1, 1};
  double BinEnd = 0.;
  double BinStart = 0.;
  double BinWidth = 0.;
  string outputname;
  string binoutputname;
  bool periodic;
  ofstream output;
  ofstream binoutput;
  std::vector< element *> elements;
  string type;
  Vector Point;
  BinPairMap *binmap = NULL;

  // obtain information
  ValueStorage::getInstance().queryCurrentValue("elements", elements);
  ValueStorage::getInstance().queryCurrentValue("bin-start", BinStart);
  ValueStorage::getInstance().queryCurrentValue("bin-width", BinWidth);
  ValueStorage::getInstance().queryCurrentValue("bin-end", BinEnd);
  ValueStorage::getInstance().queryCurrentValue("output-file", outputname);
  ValueStorage::getInstance().queryCurrentValue("bin-output-file", binoutputname);
  ValueStorage::getInstance().queryCurrentValue("periodic", periodic);

  // execute action
  output.open(outputname.c_str());
  binoutput.open(binoutputname.c_str());
  PairCorrelationMap *correlationmap = NULL;
  std::vector<molecule*> molecules = World::getInstance().getSelectedMolecules();
  if (periodic)
    correlationmap = PeriodicPairCorrelation(molecules, elements, ranges);
  else
    correlationmap = PairCorrelation(molecules, elements);
  OutputPairCorrelation(&output, correlationmap);
  binmap = BinData( correlationmap, BinWidth, BinStart, BinEnd );
  OutputCorrelation ( &binoutput, binmap );
  delete(binmap);
  delete(correlationmap);
  output.close();
  binoutput.close();
  return Action::success;
}

Action::state_ptr AnalysisPairCorrelationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisPairCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisPairCorrelationAction::canUndo() {
  return true;
}

bool AnalysisPairCorrelationAction::shouldUndo() {
  return true;
}

const string AnalysisPairCorrelationAction::getName() {
  return NAME;
}
