/*
 * GaussianThermostat.hpp
 *
 *  Created on: Aug 18, 2010
 *      Author: crueger
 */

#ifndef GAUSSIANTHERMOSTAT_HPP_
#define GAUSSIANTHERMOSTAT_HPP_

#include "Thermostats/Thermostat.hpp"

class config;

class GaussianThermostat : public Thermostat
{
public:
  GaussianThermostat(int ScaleTempStep);
  GaussianThermostat();
  virtual ~GaussianThermostat();

  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::list) atoms);
  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::vector) atoms);
  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::set) atoms);

  double getE() const;
  double getG() const;

  virtual std::string name();
  virtual std::string writeParams();
private:
  template <class ForwardIterator>
  void init(unsigned int step,ForwardIterator begin, ForwardIterator end);
  template <class ForwardIterator>
  double doScaleAtoms(unsigned int step,double ActualTemp,ForwardIterator begin, ForwardIterator end);
  double E,G;
  int ScaleTempStep;
};

template <>
struct ThermostatTraits<GaussianThermostat> : public ThermostatTraits<Thermostat>
{
  ThermostatTraits();
  virtual Thermostat *make(class ConfigFileBuffer * const fb);
  const char* name;
};

#endif /* GAUSSIANTHERMOSTAT_HPP_ */
