/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * InfoUnitTest.cpp
 *
 *  Created on: Nov 25, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "MenuDescriptionUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( MenuDescriptionTest );


void MenuDescriptionTest::setUp()
{
};


void MenuDescriptionTest::tearDown()
{
};

/** UnitTest for SensibilityTest().
 */
void MenuDescriptionTest::SensibilityTest()
{
  // from MenuSet
  for(MenuDescription::const_iterator iter = md.MenuSet.begin(); iter != md.MenuSet.end(); ++iter) {
    CPPUNIT_ASSERT_MESSAGE( "menu token not contained in MenuDescription::MenuDewscriptionsMap", md.MenuDescriptionsMap.find(*iter) != md.MenuDescriptionsMap.end());
    CPPUNIT_ASSERT_MESSAGE( "menu token not contained in MenuDescription::MenuNameMap", md.MenuNameMap.find(*iter) != md.MenuNameMap.end());
  }

  // from MenuDescriptionsMap
  for(std::map<std::string, std::string>::const_iterator iter = md.MenuDescriptionsMap.begin(); iter != md.MenuDescriptionsMap.end(); ++iter) {
    CPPUNIT_ASSERT_MESSAGE( "menu token not contained in MenuDescription::MenuSet", md.MenuSet.find(iter->first) != md.MenuSet.end());
    CPPUNIT_ASSERT_MESSAGE( "menu token not contained in MenuDescription::MenuNameMap", md.MenuNameMap.find(iter->first) != md.MenuNameMap.end());
  }

  // from MenuNameMap
  for(std::map<std::string, std::string>::const_iterator iter = md.MenuNameMap.begin(); iter != md.MenuNameMap.end(); ++iter) {
    CPPUNIT_ASSERT_MESSAGE( "menu token not contained in MenuDescription::MenuDewscriptionsMap", md.MenuDescriptionsMap.find(iter->first) != md.MenuDescriptionsMap.end());
    CPPUNIT_ASSERT_MESSAGE( "menu token not contained in MenuDescription::MenuSet", md.MenuSet.find(iter->first) != md.MenuSet.end());
  }

};
