/*
 * MenuDescription.hpp
 *
 *  Created on: Oct 26, 2010
 *      Author: heber
 */

#ifndef MENUDESCRIPTION_HPP_
#define MENUDESCRIPTION_HPP_

#include <map>
#include <set>
#include <string>

class MenuDescriptionTest;

/** Class contains information on menus.
 *
 */
class MenuDescription
{
  friend class MenuDescriptionTest;
public:
  MenuDescription();
  ~MenuDescription();

  typedef std::set<std::string>::iterator iterator;
  typedef std::set<std::string>::const_iterator const_iterator ;

  // getter for description
  const std::string getDescription(std::string token) const;
  const std::string getName(std::string token) const;

  // iterators
  iterator getBeginIter();
  iterator getEndIter();
  const_iterator getBeginIter() const;
  const_iterator getEndIter() const;

private:
  std::set<std::string> MenuSet;
  std::map<std::string, std::string> MenuDescriptionsMap;
  std::map<std::string, std::string> MenuNameMap;
};

#endif /* MENUDESCRIPTION_HPP_ */
