/*
 * verbose.hpp
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef VERBOSE_HPP_
#define VERBOSE_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>

/************************************* Class Verbose & Binary *******************************/

/** Verbose is an IO manipulator, that writes tabs according to \a Verbosity level.
 */
class Verbose
{
  public:
    Verbose(int value) : Verbosity(value) { }

    // allow access to private variable Verbose::Verbosity
    friend ostream& operator<<(class errorLogger& l, const Verbose& v);
    friend ostream& operator<<(class errorLogger* l, const Verbose& v);
    friend ostream& operator<<(class logger& l, const Verbose& v);
    friend ostream& operator<<(class logger* l, const Verbose& v);

    ostream& print (ostream &ost) const;
    bool DoOutput(int verbosityLevel) const;
  private:
    int Verbosity;
};

ostream& operator<<(ostream& ost,const Verbose& m);

/** Binary is an IO manipulator, that writes 0 and 1 according to number \a Binary.
 */
class Binary
{
  public:
    Binary(int value) : BinaryNumber(value) { }

    ostream& print (ostream &ost) const;
  private:
    int BinaryNumber;
};

ostream& operator<<(ostream& ost,const Binary& m);



#endif /* VERBOSE_HPP_ */
