/*
 * QtMenu.hpp
 *
 *  Created on: Nov 5, 2010
 *      Author: heber
 */

#ifndef MENUINTERFACEQT_HPP_
#define MENUINTERFACEQT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <Qt/qaction.h>

#include "Menu/Qt4/QMenu_tooltip.hpp"

#include <iostream>
#include <list>
#include <map>
#include <string>

#include "Menu/Menu.hpp"
#include "Menu/MenuInterface.hpp"
#include "Menu/Qt4/QtMenuPipe.hpp"

/** QtMenu is a specialization of MenuInterface to Qt-like menus.
 * I.e. with this interface we can access QMenu and QMenuBar.
 * (The latter is the reason why we have to add this additional wrapping layer).
 */
template <class T>
class QtMenu : virtual public MenuInterface, public Menu
{
public:
  explicit QtMenu(const std::string &_token) :
    MenuInterface(_token),
    Menu(_token),
    MenuInstance(new T(QString(getNameWithAccelerator(_token).c_str()))),
    deleteMenu(true)
  {}

  QtMenu(T *_Menu, const std::string &_token) :
    MenuInterface(_token),
    Menu(_token),
    MenuInstance(_Menu),
    deleteMenu(false)
  {}

  virtual ~QtMenu()
  {
    for(std::list<QtMenuPipe*>::iterator it=plumbing.begin(); it != plumbing.end(); it++)
      delete (*it);

    if (deleteMenu)
      delete MenuInstance;
  }

  T * const getMenuInstance()
  {
    return MenuInstance;
  }

protected:
  // We need to have a reference of the Menu, as Qt returns reference to added menu as well
  T *MenuInstance;

  /** Puts Qt's token, the ampersand, in front of the accelerator char in the menu name.
   * \param ActionName Action of menu
   * \return name with ampersand added at the right place
   */
  std::string getNameWithAccelerator(const std::string &ActionName)
  {
    std::string newname;
    bool Inserted = false;
    std::pair < MenuShortcutMap::iterator, bool > Inserter;
    for (std::string::const_iterator CharRunner = ActionName.begin();
        CharRunner != ActionName.end();
        ++CharRunner) {
//      std::cout << "Current char is " << *CharRunner << std::endl;
      if (!Inserted) {
        Inserter = ShortcutMap.insert(
            std::pair<char, std::string > (*CharRunner, ActionName)
            );
        if (Inserter.second) {
//          std::cout << "Accelerator is " << *CharRunner << std::endl;
          newname += '&';
          Inserted = true;
        }
      }
      newname += *CharRunner;
    }
    return newname;
  }

private:
  bool deleteMenu;
  std::list<QtMenuPipe*> plumbing;

  typedef std::map <char, std::string> MenuShortcutMap;
  MenuShortcutMap ShortcutMap;

  virtual void addActionItem(const std::string &token, const std::string &description)
  {
    QAction *action = MenuInstance->addAction(QString(getNameWithAccelerator(token).c_str()));
    action->setToolTip(QString(description.c_str()));
    action->setWhatsThis(QString(description.c_str()));
    QtMenuPipe *pipe = new QtMenuPipe(token,action);
    QObject::connect(action, SIGNAL(triggered()),pipe,SLOT(called()));
    plumbing.push_back(pipe);
  }

  virtual void addSeparatorItem()
  {
    MenuInstance->addSeparator();
  }

  virtual void addSubmenuItem(const std::string &token, const std::string &description)
  {
    QMenu_tooltip *Menu = new QMenu_tooltip(QString(token.c_str()));
    MenuInstance->addMenu(Menu);
    QtMenu<QMenu_tooltip> *NewMenu = new QtMenu<QMenu_tooltip>(Menu, token);
    NewMenu->init();
  }

};

#endif /* MENUINTERFACEQT_HPP_ */
